//     "Get The Fruit"
// A 2005 SpeedHack entry
//      By, Ben goska

#include <allegro.h>
#include <cmath>
#include <list>
#include <vector>

#include "global.h"
#include "bullet.h"
#include "explode.h"
#include "enemy.h"
#include "fruit.h"

enum {GameStateTitle, GameStateMenu, GameStateInGame, GameStateInGameMenu, GameStatePreLevel, GameStateWorld, GameStateInstructions, GameStateLost, GameStateQuit};

volatile int timerVar = 0;
bool mouseInput = false;
bool useVsync = false;
int numberOfFruitLeft = 0;
int screenShake = 0;

void timerFunc()
{
	timerVar++;
}

void generateMap()
{
	//generate map
	for(int i = 0; i < 20; i++)
	{
		for(int c = 0; c < 15; c++)
		{
			int temp = rand() % 64;
			if(temp > 4)
				temp = 0;
			theMap[i][c] = temp;
			temp = rand() % 300;
			if(temp < 20)
				collisionMap[i][c] = 1;
			else
				collisionMap[i][c] = 0;
			
			if((i == 0)||(i == 19)||(c == 0)||(c == 14)) //wall around the edges
				collisionMap[i][c] = 1;
				
		}
	}
	
	//run through again and smooth blocking blocks
	for(int i = 0; i < 20; i++)
	{
		for(int c = 0; c < 15; c++)
		{
			if(collisionMap[i][c])
			{
				int temp = 0;
				if((i != 0)&&(collisionMap[i - 1][c]))
					temp += 1;
				if((c != 14)&&(collisionMap[i][c + 1]))
					temp += 2;
				if((i != 19)&&(collisionMap[i + 1][c]))
					temp += 4;
				if((c != 0)&&(collisionMap[i][c - 1]))
					temp += 8;
				theMap[i][c] = 5 + temp;
			}
		}
	}
}

void doBulletStuff(SAMPLE *explode, SAMPLE *fruitSound)
{
	bool enemyCollision = false;
	for(std::list<bullet>::iterator i = theBullets.begin(); i != theBullets.end(); i++)
	{
		enemyCollision = false;
		(*i).update();
				
		for(std::list<enemy>::iterator j = theEnemies.begin(); j != theEnemies.end(); j++)
		{
			if(checkCircles((*i).getX(), (*i).getY(), 1.0f, (*j).getX(), (*j).getY(), 4.0f))
			{
				(*j).damage();
						
				explosion exploder((*i).getX(), (*i).getY(), (*i).getCol());
				theExplosions.push_back(exploder);
						
				if((*j).destroyed())
				{
					explosion biggin((*j).getX(), (*j).getY(), !(*i).getCol(), true);
					theExplosions.push_back(biggin);
					
					//add fruit!
					if((*j).getType() == EnemyTypeContainer)
					{
						fruit newFruit((*j).getX(), (*j).getY());
						theFruit.push_back(newFruit);
					}
					
					theEnemies.erase(j);
					
					flashLevel = 255.0f;
				}
						
				i = theBullets.erase(i);
				play_sample(explode, 192, 128, 1000 + (rand() % 100), 0);
				enemyCollision = true;
				break;
						
			}
		}
				
		if((!enemyCollision)&&(collisionMap[(int)(*i).getX() / 8][(int)(*i).getY() / 8]))
		{
			//add an explosion!
			explosion exploder((*i).getX(), (*i).getY(), (*i).getCol());
			theExplosions.push_back(exploder);
			i = theBullets.erase(i);
			play_sample(explode, 192, 128, 1000 + (rand() % 100), 0);
			
		}
		
	}
	
	for(std::list<bullet>::iterator i = enemyBullets.begin(); i != enemyBullets.end(); i++)
	{
		enemyCollision = false;
		(*i).update();
		if(checkCircles((*i).getX(), (*i).getY(), 1.0f, PlayerX, PlayerY, 4.0f))
		{
			enemyCollision = true;
			PlayerH = PlayerH - 2.0f;
			screenShake = 100;
		}
		
		if((collisionMap[(int)(*i).getX() / 8][(int)(*i).getY() / 8])||(enemyCollision))
		{
			//add an explosion!
			explosion exploder((*i).getX(), (*i).getY(), (*i).getCol());
			theExplosions.push_back(exploder);
					
			i = enemyBullets.erase(i);
			play_sample(explode, 192, 128, 1000 + (rand() % 100), 0);
					
		}
				
	}
}

void checkFruit(SAMPLE *fruits)
{
	for(std::list<fruit>::iterator i = theFruit.begin(); i != theFruit.end(); i++)
	{
		if(checkCircles(PlayerX, PlayerY, 4.0f, (*i).getX(), (*i).getY(), 3.0f))
		{
			play_sample(fruits, 255, 128, 1300, 0);
			i = theFruit.erase(i);
			PlayerS += 20.0f;
			if(PlayerS > 101.0f)
				PlayerS = 101.0f;
			numberOfFruitLeft--;
		}
	}
}

bool findLocationForPlayer(float &X, float &Y)
{
	std::vector<int> Xes;
	std::vector<int> Yes;
	for(int x2 = 0; x2 < 20; x2++)
	{
		for(int y2 = 0; y2 < 15; y2++)
		{
			if((!collisionMap[x2][y2])&&(!checkEnemies(x2 * 8.0f + 4.0f, y2 * 8.0f + 4.0f, 4.0f)))
			{
				Xes.push_back(x2);
				Yes.push_back(y2);
			}
		}
	}
	
	std::vector<float> DistEnemy;
	std::vector<float> DistCenter;
	
	for(unsigned int i = 0; i < Xes.size(); i++)
	{
		float high = 0.0f;
		float temp;
		for(std::list<enemy>::iterator j = theEnemies.begin(); j != theEnemies.end(); j++)
		{
			temp = getDistance((Xes[i] * 8.0f + 4.0f), (Yes[i] * 8.0f + 4.0f), (*j).getX(), (*j).getY());
			if(temp > high)
				high = temp;
		}
		DistEnemy.push_back(high);
		DistCenter.push_back(getDistance((Xes[i] * 8.0f + 4.0f), (Yes[i] * 8.0f + 4.0f), 80.0f, 60.0f));
	}
	
	int bestIndex = 0;
	
	for(unsigned int i = 1; i < DistEnemy.size(); i++)
		if((DistEnemy[i] > DistEnemy[bestIndex])||((DistEnemy[i] == DistEnemy[bestIndex])&&(DistCenter[i] < DistCenter[bestIndex])))
			bestIndex = i;
	
	X = Xes[bestIndex] * 8.0f + 4.0f;
	Y = Yes[bestIndex] * 8.0f + 4.0f;
	
	return true;
}

int init()
{
	srand(time(NULL));
	allegro_init();
	install_keyboard();
	install_mouse();
	install_timer();
	
	if(install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL))
	{
		allegro_message("Error installing sound!\nError: %s", allegro_error);
		return 1;
	}
	
	
	
	LOCK_VARIABLE(timerVar);
	LOCK_FUNCTION(timerFunc);
	
	install_int_ex(timerFunc, BPS_TO_TIMER(100));
	
	text_mode(-1);
	
	int colorDepth = 0;
	int fullScreen = 0;
	push_config_state();
	set_config_file("config.cfg");
	colorDepth = get_config_int("graphics", "color_depth", 16);
	if(colorDepth == -1)
		colorDepth = desktop_color_depth();
	if(colorDepth == 0)
		colorDepth = 16;
	if(colorDepth == 8)
		allegro_message("WARNING! 8-bit color is NOT SUPPORTED\n");
	
	fullScreen =  get_config_int("graphics", "fullscreen", 0);
	int tempInt = get_config_int("input", "use_mouse", 1);
	if(tempInt)
		mouseInput = true;
	tempInt = get_config_int("graphics", "vsync", 1);
	if(tempInt)
		useVsync = true;
	
	pop_config_state();
	
	if(fullScreen)
	{
		fullScreen = GFX_AUTODETECT_FULLSCREEN;
	}
	else
	{
		fullScreen = GFX_AUTODETECT_WINDOWED;
	}
	
	set_color_depth(colorDepth);
	
	if(set_gfx_mode(fullScreen, 640, 480, 0, 0))
	{
		allegro_message("Unable to set mode... attempting safe\nError: %s", allegro_error);
		if(set_gfx_mode(GFX_SAFE, 640, 480, 0, 0))
		{
			allegro_message("GFX error! (safe mode failed.. something is wrong)\nError: %s", allegro_error);
			return 1;
		}
	}
	
	return 0;
}

int main()
{
	
	
	if(init())
		return 1;
	
	BITMAP *doubleBuffer = create_bitmap(160, 120);
	BITMAP *transBuffer = create_bitmap(160, 120);
	BITMAP *shakeBuffer = create_bitmap(160, 120);
	clear_to_color(transBuffer, makecol(255, 255, 255));
	
	textout_centre(doubleBuffer, font, "Loading...", 80, 55, makecol(255, 255, 255));
	stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
	
	
	//load bitmaps
	BITMAP *playerBitmap = load_bmp("player.bmp", NULL);
	BITMAP *enemyBitmap = load_bmp("enemy.bmp", NULL);
	BITMAP *enemyShooterBitmap = load_bmp("enemyshot.bmp", NULL);
	BITMAP *enemyRoamerBitmap = load_bmp("enemyroam.bmp", NULL);
	BITMAP *crossHair = load_bmp("crosshair.bmp", NULL);
	BITMAP *fruitBitmap = load_bmp("fruit.bmp", NULL);
	BITMAP *titleBitmap = load_bmp("title.bmp", NULL);
	BITMAP *mapBitmap = load_bmp("map.bmp", NULL);
	
	if((!playerBitmap)||(!enemyBitmap)||(!enemyShooterBitmap)||(!enemyRoamerBitmap)||(!crossHair)||(!fruitBitmap)||(!titleBitmap)||(!mapBitmap))
	{
		allegro_message("Can't find image files!\n");
		return 1;
	}
	
	BITMAP *tiles[21];
	
	tiles[0] = load_bmp("dirt.bmp", NULL);
	tiles[1] = load_bmp("dirt1.bmp", NULL);
	tiles[2] = load_bmp("dirt2.bmp", NULL);
	tiles[3] = load_bmp("dirt3.bmp", NULL);
	tiles[4] = load_bmp("dirt4.bmp", NULL);
	tiles[5] = load_bmp("wall.bmp", NULL);
	
	tiles[6] = load_bmp("wallsingleft.bmp", NULL); //1
	tiles[7] = load_bmp("wallsingdown.bmp", NULL); //2 
	tiles[8] = load_bmp("wallupright.bmp", NULL); //3
	tiles[9] = load_bmp("wallsingright.bmp", NULL); //4
	tiles[10] = load_bmp("wallhor.bmp", NULL); //5
	tiles[11] = load_bmp("wallupleft.bmp", NULL); //6
	tiles[12] = load_bmp("walltridown.bmp", NULL); //7
	tiles[13] = load_bmp("wallsingup.bmp", NULL); //8
	tiles[14] = load_bmp("wallbotright.bmp", NULL); //9
	tiles[15] = load_bmp("wallvert.bmp", NULL); //10
	tiles[16] = load_bmp("walltrileft.bmp", NULL); //11
	tiles[17] = load_bmp("wallbotleft.bmp", NULL); //12
	tiles[18] = load_bmp("walltriup.bmp", NULL); //13
	tiles[19] = load_bmp("walltriright.bmp", NULL); //14
	tiles[20] = load_bmp("wallquad.bmp", NULL); //15
	
	for(int i = 0; i < 21; i++)
	{
		if(!tiles[i])
		{
			allegro_message("Can't find image files!\n");
			return 1;
		}
	}
	
	//load sound files
	SAMPLE *shotgunSound = load_wav("shotgun.wav");
	SAMPLE *boomSound = load_wav("boom.wav");
	SAMPLE *fruitSound = load_wav("drop.wav");
	SAMPLE *getTheFruitSound = load_wav("gtf.wav");
	
	if((!shotgunSound)||(!boomSound)||(!fruitSound))
	{
		allegro_message("Can't find sound files!\n");
		return 1;
	}
	
	int gameState = GameStateTitle;
	bool playerPing = true;
	float playerPingDistance = 100.0f;
	float fireTimer = 0.0f;
	float targetX, targetY;
	int menuSelection = 0;
	int level = 0;
	
	timerVar = 0;
	while(gameState != GameStateQuit)
	{
		if(timerVar > 100) //no logic for a seccond, thats bad
			timerVar = 0; //reset (IE logic skipping) in case of a slow computer
		
		if(timerVar > 0)
		{
			//logic
			switch(gameState)
			{
				case GameStateTitle:
				{
					static int counter = 0;
					level = 0;
					if(key[KEY_ENTER])
					{
						gameState = GameStateMenu;
						while(key[KEY_ENTER])
						{}
						int ang = rand() % 256;
						int d = rand() % 35;
						targetX = 80.0f + (float)d * cos(angToRad((float)ang));
						targetY = 80.0f + (float)d * sin(angToRad((float)ang));
						playerPingDistance = 100.0f;
						timerVar = 0;
					}

					if(key[KEY_ESC])
						gameState = GameStateQuit;
					counter++;
					if(counter >= 40)
					{
						playerPing = !playerPing;
						counter = 0;
					}
					break;
				}
				case GameStateWorld:
				{
					playerPingDistance -= 1.0f;
					
					if(playerPingDistance < 4.0f)
						playerPingDistance = 4.0f;
					if(key[KEY_ENTER])
					{
						gameState = GameStatePreLevel;
						while(key[KEY_ENTER])
						{}
					}
					if(key[KEY_ESC])
						gameState = GameStateQuit;
					break;
				}
				case GameStatePreLevel:
				{
					numberOfFruitLeft = 0;
					theBullets.clear();
					theEnemies.clear();
					enemyBullets.clear();
					theFruit.clear();
					theExplosions.clear();
					generateMap();
					
					for(int i = 0; i < level; i++)
					{
						enemy theEnemy(1);
						theEnemies.push_back(theEnemy);
					}
					for(int i = 0; i < (level + 1) * 2; i++)
					{
						enemy theEnemy(0);
						enemy theEnemy2(rand() % 3);
						theEnemies.push_back(theEnemy);
						theEnemies.push_back(theEnemy2);
					}
					
					for(std::list<enemy>::iterator i = theEnemies.begin(); i != theEnemies.end(); i++)
						if((*i).getType() == 0)
							numberOfFruitLeft++;
						
					if(!findLocationForPlayer(PlayerX, PlayerY))
						return 1;
					
					playerPing = true;
					playerPingDistance = 150.0f;
					PlayerH = 100.0f;
					PlayerS = 0.0f;
					fireTimer = 0.0f;
					gameState = GameStateInGame;
					if(level == 0)
						for(int c = 0; c < 5; c++)
							play_sample(getTheFruitSound, 255, 128, 1000, 0);
					break;
				}
				case GameStateInGameMenu:
				{
					if(key[KEY_ENTER])
					{
						while(key[KEY_ENTER])
						{}
						switch(menuSelection)
						{
							case 0:
							{
								gameState = GameStateInGame;
								timerVar = 0;
								break;
							}
							case 1:
							{
								if(timeAdjuster > 0.9f)
									timeAdjuster = 0.3f;
								else
									timeAdjuster = 1.0f;
								break;
							}
							case 2:
							{
								if(tankAdjuster < 1.1f)
									tankAdjuster = 2.0f;
								else
									tankAdjuster = 1.0f;
								break;
							}
							case 3:
							{
								gameState = GameStateQuit;
								break;
							}
						}
						
					}
					if(key[KEY_RSHIFT])
					{
						menuSelection++;
						if(menuSelection == 4)
							menuSelection = 0;
						while(key[KEY_RSHIFT])
						{ }
					}
					
					if(key[KEY_ESC])
						gameState = GameStateQuit;
					
					break;
				}
				case GameStateInstructions:
				{
					if(key[KEY_ENTER])
					{
						while(key[KEY_ENTER])
						{}
						gameState = GameStateMenu;
						timerVar = 0;
					}
					break;
				}
				case GameStateMenu:
				{
					if(key[KEY_ENTER])
					{
						while(key[KEY_ENTER])
						{}
						switch(menuSelection)
						{
							case 0:
							{
								gameState = GameStateWorld;
								timerVar = 0;
								break;
							}
							case 1:
							{
								gameState = GameStateInstructions;
								timerVar = 0;
								break;
							}
							case 2:
							{
								gameState = GameStateQuit;
								break;
							}
						}
					
					}
				
					if(key[KEY_RSHIFT])
					{
						menuSelection++;
						if(menuSelection == 3)
							menuSelection = 0;
						while(key[KEY_RSHIFT])
						{ }
					}
					
					if(key[KEY_ESC])
						gameState = GameStateQuit;
					
					break;
				}
				case GameStateLost:
				{
					if(key[KEY_ENTER])
					{
						while(key[KEY_ENTER])
						{}
						gameState = GameStateTitle;
					}
					
					if(key[KEY_ESC])
						gameState = GameStateQuit;
					break;
				}
				case GameStateInGame:
				{
					if(numberOfFruitLeft == 0)
					{
						gameState = GameStateWorld;
						int ang = rand() % 256;
						int d = rand() % 35;
						targetX = 80.0f + (float)d * cos(angToRad((float)ang));
						targetY = 80.0f + (float)d * sin(angToRad((float)ang));
						playerPingDistance = 100.0f;
						timerVar = 0;
						level++;
					}
					
					if(PlayerH <= 0.0f)
					{
						gameState = GameStateLost;
					}
					
					if(key[KEY_ESC])
						gameState = GameStateQuit;
					
					if(key[KEY_ENTER])
					{
						while(key[KEY_ENTER])
						{ }
						gameState = GameStateInGameMenu;
						menuSelection = 0;
						timerVar = 0;
					}
					
					if(((key[KEY_W])&&(mouseInput))||((!mouseInput)&&(key[KEY_UP])))
					{
						float deltaX = tankAdjuster * timeAdjuster * 0.5f * cos((double)angToRad(PlayerA - 64.0f));
						float deltaY = tankAdjuster * timeAdjuster * 0.5f * sin((double)angToRad(PlayerA - 64.0f));
						
						PlayerX = PlayerX + deltaX;
						if(collisionMap[(int)PlayerX / 8][(int)PlayerY / 8])
							PlayerX -= deltaX;
						
						PlayerY = PlayerY + deltaY;
						if(collisionMap[(int)PlayerX / 8][(int)PlayerY / 8])
							PlayerY -= deltaY;
						
					}
					if(((key[KEY_S])&&(mouseInput))||((!mouseInput)&&(key[KEY_DOWN])))
					{
						float deltaX = tankAdjuster * timeAdjuster * -0.5f * cos((double)angToRad(PlayerA - 64.0f));
						float deltaY = tankAdjuster * timeAdjuster * -0.5f * sin((double)angToRad(PlayerA - 64.0f));
						
						PlayerX = PlayerX + deltaX;
						if(collisionMap[(int)PlayerX / 8][(int)PlayerY / 8])
							PlayerX -= deltaX;
						
						PlayerY = PlayerY + deltaY;
						if(collisionMap[(int)PlayerX / 8][(int)PlayerY / 8])
							PlayerY -= deltaY;
					}
					
					if((!mouseInput)&&(key[KEY_LEFT]))
						PlayerA -= tankAdjuster * timeAdjuster * 2.0f;
					if((!mouseInput)&&(key[KEY_RIGHT]))
						PlayerA += tankAdjuster * timeAdjuster * 2.0f;
					
					if(mouseInput)
						PlayerA = getAngle(PlayerX, PlayerY, getMouseX(), getMouseY());
					
					
					
					if(((mouse_b & 1)||((key[KEY_SPACE])&&(!mouseInput)))&&(fireTimer >= (100.0f / tankAdjuster)))
					{
						int random = rand() % 5 + 5;
						while(random > 0)
						{
							float angle;
							if(mouseInput)
								angle = getAngle(PlayerX, PlayerY, getMouseX(), getMouseY());
							else
								angle = PlayerA;
							int random2 = rand() % 32 - 16;
							bullet *newBull = new bullet(PlayerX, PlayerY, angle + (float)random2);
							theBullets.push_back(*newBull);
							play_sample(shotgunSound, 128, 128, 1000 + (rand() % 100), 0);
							delete newBull;
							random--;
						}
						fireTimer = 0.0f;
						
					}
					else if(((mouse_b & 2)||((key[KEY_LCONTROL])&&(!mouseInput)))&&(fireTimer >= (100.0f / tankAdjuster)))
					{
						float angle;
						if(mouseInput)
							angle = getAngle(PlayerX, PlayerY, getMouseX(), getMouseY());
						else
							angle = PlayerA;
						bullet newBull(PlayerX, PlayerY, angle);
						theBullets.push_back(newBull);
						fireTimer = 0.0f;
						//play shotgun sound
						play_sample(shotgunSound, 255, 128, 1300 + (rand() % 100), 0);
					}
					
					doBulletStuff(boomSound, getTheFruitSound);
					
					for(std::list<explosion>::iterator i = theExplosions.begin(); i != theExplosions.end(); i++)
					{
						(*i).update();
						if((*i).clearIt())
							i = theExplosions.erase(i);
					}
					
					bool hit = false;
					for(std::list<enemy>::iterator i = theEnemies.begin(); i != theEnemies.end(); i++)
					{
						(*i).update();
						if(hit)
							continue;
						if(checkCircles(PlayerX, PlayerY, 4.0f, (*i).getX(), (*i).getY(), 4.0f))
						{
							PlayerH -= 0.1f * timeAdjuster;
							hit = true;
						}
					}
					
					checkFruit(fruitSound);
					
					if(flashLevel > 0.0f)
						flashLevel -= 4.0f * timeAdjuster;
					if(flashLevel < 0.0f)
						flashLevel = 0.0f;
					if(flashLevel > 255.0f)
						flashLevel = 255.0f;
					
					if((key[KEY_LCONTROL])&&(mouseInput))
						tankAdjuster = 2.0f;
					if((key[KEY_LSHIFT])&&(mouseInput))
						timeAdjuster = 0.3f;
					
					if(timeAdjuster < 0.9f)
						PlayerS -= 0.025f;
					if(tankAdjuster > 1.1f)
						PlayerS -= 0.025f;
					
					if(PlayerS < 0.0f)
					{
						PlayerS = 0.0f;
						timeAdjuster = 1.0f;
						tankAdjuster = 1.0f;
					}
					
					fireTimer++;
					if(fireTimer >= (100.0f / tankAdjuster))
						fireTimer = 100.0f / tankAdjuster;
					if(playerPing)
						playerPingDistance -= 2.0f;
					if(playerPingDistance < 8.0f)
						playerPing = false;
					if(screenShake > 0)
						screenShake--;
					break;
				}
			}
			timerVar--;
		}
		else
		{
			//draw
			switch(gameState)
			{
				case GameStateTitle:
				{
					blit(titleBitmap, doubleBuffer, 0, 0, 0, 0, 160, 120);
					if(playerPing)
					{
						if(!mouseInput)
							textout_centre(doubleBuffer, font, "[Press Start]", 80, 100, makecol(255, 255, 255));
						else
							textout_centre(doubleBuffer, font, "[Press Enter]", 80, 100, makecol(255, 255, 255));
					}
					
					if(useVsync)
						vsync();
					
					stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					break;
				}
				case GameStateWorld:
				{
					blit(mapBitmap, doubleBuffer, 0, 0, 0, 0, 160, 120);
					rect(doubleBuffer, (int)(targetX - playerPingDistance), (int)(targetY - playerPingDistance), (int)(targetX + 4.0f + playerPingDistance), (int)(targetY + 4.0f + playerPingDistance), makecol(255, 255, 255));
					rect(doubleBuffer, (int)(targetX - playerPingDistance) + 1, (int)(targetY - playerPingDistance) + 1, (int)(targetX + 4.0f + playerPingDistance) - 1, (int)(targetY + 4.0f + playerPingDistance) - 1, makecol(0, 0, 0));
					
					if(useVsync)
						vsync();
					
					stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					break;
				}
				case GameStateInstructions:
				{
					clear(doubleBuffer);
					
					/*
					12345678901234567890
					   Welcome to Get 
					the Fruit. Just blow
					up enemies and get 
					the boxes of fruit.
					It's that simple!
					
					Lets get fruity!
					
					*/
					
					textout(doubleBuffer, font, "   Welcome to Get", 0, 0, makecol(255, 255, 255));
					textout(doubleBuffer, font, "the Fruit. Just blow", 0, 10, makecol(255, 255, 255));
					textout(doubleBuffer, font, "up enemies and get", 0, 20, makecol(255, 255, 255));
					textout(doubleBuffer, font, "the boxes of fruit", 0, 30, makecol(255, 255, 255));
					textout(doubleBuffer, font, "It's that simple!", 0, 40, makecol(255, 255, 255));
					
					textout(doubleBuffer, font, "Lets get fruity!", 0, 60, makecol(255, 255, 255));
					
					if(mouseInput)
						textout(doubleBuffer, font, "[Press Enter]", 0, 110, makecol(255, 255, 255));
					else
						textout(doubleBuffer, font, "[Press Start]", 0, 110, makecol(255, 255, 255));
					
					if(useVsync)
						vsync();
					
					stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					
					break;
				}
				case GameStateLost:
				{
					clear(doubleBuffer);
					textprintf_centre(doubleBuffer, font, 80, 51, makecol(255,255,255), "You made it to");
					textprintf_centre(doubleBuffer, font, 80, 61, makecol(255,255,255), "level: %i", level);
					
					if(useVsync)
						vsync();
					
					stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					
					break;
				}
				case GameStateMenu:
				{
					clear(doubleBuffer);
					if(menuSelection == 0)
						textout_centre(doubleBuffer, font, "> Play <", 80, 45, makecol(255, 255, 255));
					else
						textout_centre(doubleBuffer, font, "Play", 80, 45, makecol(255, 255, 255));
					if(menuSelection != 1)
						textout_centre(doubleBuffer, font, "Instructions", 80, 55, makecol(255, 255, 255));
					else
						textout_centre(doubleBuffer, font, "> Instructions <", 80, 55, makecol(255, 255, 255));
					if(menuSelection != 2)
						textout_centre(doubleBuffer, font, "Quit", 80, 65, makecol(255, 255, 255));
					else
						textout_centre(doubleBuffer, font, "> Quit <", 80, 65, makecol(255, 255, 255));
					
					if(useVsync)
						vsync();
					
					stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					break;
				}
				case GameStateInGameMenu:
				{
					clear(doubleBuffer);
					if(menuSelection == 0)
						textout_centre(doubleBuffer, font, "> Resume <", 80, 40, makecol(255, 255, 255));
					else
						textout_centre(doubleBuffer, font, "Resume", 80, 40, makecol(255, 255, 255));
					if(timeAdjuster > 0.9f)
					{
						if(menuSelection == 1)
							textout_centre(doubleBuffer, font, "> Activate Slow <", 80, 50, makecol(255, 255, 255));
						else
							textout_centre(doubleBuffer, font, "Activate Slow", 80, 50, makecol(255, 255, 255));
					}
					else
					{
						if(menuSelection != 1)
							textout_centre(doubleBuffer, font, "Disable Slow", 80, 50, makecol(255, 255, 255));
						else
							textout_centre(doubleBuffer, font, "> Disable Slow <", 80, 50, makecol(255, 255, 255));
					}
					if(tankAdjuster < 1.1f)
					{
						if(menuSelection != 2)
							textout_centre(doubleBuffer, font, "Activate Speed", 80, 60, makecol(255, 255, 255));
						else
							textout_centre(doubleBuffer, font, "> Activate Speed <", 80, 60, makecol(255, 255, 255));
					}
					else
					{
						if(menuSelection != 2)
							textout_centre(doubleBuffer, font, "Disable Speed", 80, 60, makecol(255, 255, 255));
						else
							textout_centre(doubleBuffer, font, "> Disable Speed <", 80, 60, makecol(255, 255, 255));
					}
					
					if(menuSelection != 3)
						textout_centre(doubleBuffer, font, "Quit", 80, 70, makecol(255, 255, 255));
					else
						textout_centre(doubleBuffer, font, "> Quit <", 80, 70, makecol(255, 255, 255));
					
					if(useVsync)
						vsync();
					
					stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					break;
				}
				case GameStateInGame:
				{
					for(int i = 0; i < 20; i++)
						for(int c = 0; c < 15; c++)
							blit(tiles[theMap[i][c]], doubleBuffer, 0, 0, 8 * i, 8 * c, 8, 8);
					
					for(std::list<enemy>::iterator i = theEnemies.begin(); i != theEnemies.end(); i++)
					{
						switch((*i).getType())
						{
							case EnemyTypeContainer:
								(*i).draw(doubleBuffer, enemyBitmap);
								break;
							case EnemyTypeShooter:
								(*i).draw(doubleBuffer, enemyShooterBitmap);
								break;
							case EnemyTypeRoamer:
								(*i).draw(doubleBuffer, enemyRoamerBitmap);
								break;
							case EnemyTypeTeleDodge:
								
								break;
						}
					}
					
					rotate_sprite(doubleBuffer, playerBitmap, ((int)PlayerX) - (playerBitmap->w/2), ((int)PlayerY) - (playerBitmap->h/2), ftofix(PlayerA));
					
					for(std::list<fruit>::iterator i = theFruit.begin(); i != theFruit.end(); i++)
						(*i).draw(doubleBuffer, fruitBitmap);
					
					for(std::list<explosion>::iterator i = theExplosions.begin(); i != theExplosions.end(); i++)
						(*i).draw(doubleBuffer);
					
					for(std::list<bullet>::iterator i = theBullets.begin(); i != theBullets.end(); i++)
						(*i).draw(doubleBuffer);
					
					for(std::list<bullet>::iterator i = enemyBullets.begin(); i != enemyBullets.end(); i++)
						(*i).draw(doubleBuffer);
					
					if(playerPing)
						rect(doubleBuffer, (int)(PlayerX - 4.0f - playerPingDistance), (int)(PlayerY - 4.0f - playerPingDistance), (int)(PlayerX + 4.0f + playerPingDistance), (int)(PlayerY + 4.0f + playerPingDistance), makecol(255, 255, 255));
					
					if(mouseInput)
						draw_sprite(doubleBuffer, crossHair, mouse_x/4, mouse_y/4);
					else
						draw_sprite(doubleBuffer, crossHair, (int)(PlayerX + 20.0f * cos(angToRad(PlayerA - 64.0f))), (int)(PlayerY + 20.0f * sin(angToRad(PlayerA - 64.0f))));
					
					//text_mode(-1);
					//textprintf(doubleBuffer, font, 0, 0, makecol(255, 255, 0), "%i", theEnemies.size());
					
					rect(doubleBuffer, 28, 2, 130, 5, makecol(255, 255, 255));
					rectfill(doubleBuffer, 29, 3, 29 + (int)PlayerH, 4, makecol(0, 0, 0));
					
					
					rectfill(doubleBuffer, 28, 115, 28 + (int)PlayerS, 116, makecol(0, 0, 0));
					rect(doubleBuffer, 28, 114, 130, 117, makecol(255, 255, 255));
					
					drawing_mode(DRAW_MODE_TRANS, NULL, 0, 0);
					set_trans_blender(0, 0, 0, (int)flashLevel);
					draw_trans_sprite(doubleBuffer, transBuffer, 0, 0);
					drawing_mode(DRAW_MODE_SOLID, NULL, 0, 0);
					
					if(useVsync)
						vsync();
					if(screenShake > 0)
					{
						int xOff = rand() % 6 - 3;
						int yOff = rand() % 6 - 3;
						clear(shakeBuffer);
						blit(doubleBuffer, shakeBuffer, 0, 0, xOff, yOff, 160, 120);
						stretch_blit(shakeBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					}
					else
					{
						stretch_blit(doubleBuffer, screen, 0, 0, 160, 120, 0, 0, SCREEN_W, SCREEN_H);
					}
					break;
				}
			}
		}
	}
	
	//clean up
	destroy_bitmap(doubleBuffer);
	destroy_bitmap(playerBitmap);
	destroy_bitmap(crossHair);
	destroy_bitmap(enemyBitmap);
	destroy_bitmap(enemyShooterBitmap);
	destroy_bitmap(enemyRoamerBitmap);
	destroy_bitmap(transBuffer);
	destroy_bitmap(fruitBitmap);
	destroy_bitmap(titleBitmap);
	destroy_bitmap(mapBitmap);
	
	for(int i = 0; i < 21; i++)
		destroy_bitmap(tiles[i]);
	
	destroy_sample(boomSound);
	destroy_sample(shotgunSound);
	destroy_sample(fruitSound);
	destroy_sample(getTheFruitSound);
	
	return 0;
}
END_OF_MAIN()

